/* Specify the prior probability  */
/* to correct for oversampling    */
%let pi1=.02;  

/* Calculate the response rate in */
/* the sample, and save it in a   */
/* macro variable                 */
proc SQL noprint;
  select mean(INS) into :rho1 from develop;
quit;

/* Put an offset variable, OFF, on the data */
data develop;
   set develop;
   off=log(((1-&pi1)*&rho1)/(&pi1*(1-&rho1)));
run;

/* Use the OFFSET= option on the model statement */
/* to correct the intercept term                 */
proc logistic data=develop des outest=betas2;
   model ins=dda ddabal dep depamt cashbk checks
   / offset=off;
run;

proc score data=pmlr.new out=scored score=betas2 type=parms;
   var dda ddabal dep depamt cashbk checks;
run;

data scored;
   set scored;
   p=1/(1+exp(-ins));
run;

proc print data=scored(obs=20);
   var p ins dda ddabal dep depamt cashbk checks;
run;


